local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	local imglist1 = CtlImageList_class:create();
	imglist1:Add( "icons/silk/16/user" );
	imglist1:Add( "icons/silk/16/user_red" );
	imglist1:Add( "icons/silk/16/add_user" );
	imglist1:Add( "icons/silk/16/delete_user" );
	imglist1:Add( "icons/silk/16/user_edit" );
	
	
	
	// create the users list
	self.Header1 = CtlHeader_class:create( self );
	self.Header1:SetPos( 4, 4 );
	self.Header1:SetSize( 128, 32 );
	self.Header1:SetTitle( "Players" );
	
	self.Body1 = CtlBody_class:create( self );
	self.Body1:SetPos( 4, 38 );
	self.Body1:SetSize( 128, 96 );
	
	self.List1 = CtlListBox_class:create( self.Body1:GetHandle() );
	self.List1:SetPos( 4, 40 );
	self.List1:SetSize( 32, 96 );
	self.List1:SetImageList( imglist1 );
	self.List1:AddEvent( "OnItemSelected", "OnUserSelected", self );
	
	self.Button1 = CtlButton_class:create( self.Body1:GetHandle() );
	self.Button1:SetText( "Add" );
	self.Button1:SetImageList( imglist1 );
	self.Button1:SetIcon( 3 );
	self.Button1:AddEvent( "OnClick", "OnAddUser", self );
	
	
	
	// create the admins list
	self.Header2 = CtlHeader_class:create( self );
	self.Header2:SetPos( 4, 4 );
	self.Header2:SetSize( 128, 32 );
	self.Header2:SetTitle( "Admins" );
	
	self.Body2 = CtlBody_class:create( self );
	self.Body2:SetPos( 4, 38 );
	self.Body2:SetSize( 128, 96 );
	
	self.List2 = CtlListBox_class:create( self.Body2:GetHandle() );
	self.List2:SetPos( 4, 40 );
	self.List2:SetSize( 32, 96 );
	self.List2:SetImageList( imglist1 );
	self.List2:AddEvent( "OnItemSelected", "OnAdminSelected", self );
	
	self.Button2 = CtlButton_class:create( self.Body2:GetHandle() );
	self.Button2:SetText( "Change Access" );
	self.Button2:SetImageList( imglist1 );
	self.Button2:SetIcon( 5 );
	//self.Button1:AddEvent( "OnClick", "OnAddUser", self );
	
	self.Button3 = CtlButton_class:create( self.Body2:GetHandle() );
	self.Button3:SetText( "Remove" );
	self.Button3:SetImageList( imglist1 );
	self.Button3:SetIcon( 4 );
	self.Button3:AddEvent( "OnClick", "OnRemoveAdmin", self );
	
	
	
	// next think
	self.NextUpdate = CurTime() + 4;
	
	
	// current user.
	self.User = nil;
	self.Admin = nil;
	
	
end



// they want to add an admin.
function PANEL:OnAddUser( )
	// do we have a user selected?
	if( !self.User || !self.User:IsValid() || !self.User:GetNetworkedString( "steamid" ) ) then return; end
	
	// add them.
	LocalPlayer():ConCommand(
		"VMF_AddAdmin \"" .. self.User:GetNetworkedString( "steamid" ) .. "\" \"\" \"" .. self.User:Name() .. "\"\n"
	);
	
//	print( "VMF_AddAdmin \"" .. self.User:GetNetworkedString( "steamid" ) .. " \"\" \"" .. self.User:Name() .. "\"\n" );
	
	// reduce the update time
	self.NextUpdate = CurTime() + 0.5;

end


// they want to remove
function PANEL:OnRemoveAdmin( )
	// do we have a user selected?
	if( !self.Admin ) then return; end
	
	// add them.
	LocalPlayer():ConCommand(
		"VMF_RemoveAdmin \"" .. self.Admin .. "\"\n"
	);
	
	print( "VMF_RemoveAdmin \"" .. self.Admin .. "\"\n" );
	
	// reduce the update time
	self.NextUpdate = CurTime() + 0.5;

end


// user was clicked
function PANEL:OnUserSelected( item )
	self.User = item.Player;

end


// admin was clicked
function PANEL:OnAdminSelected( item )
	self.Admin = item.SteamID;

end

// think. update users list.
function PANEL:Think( )
	if( self.NextUpdate > CurTime() ) then return; end
	self.NextUpdate = CurTime() + 5;
	
	// update ze list!
	local players = player.GetAll();
	
	// existing items
	local existing_players = {};
	
	// remove any listbox items that don't have a player anymore.
	local i;
	for i = self.List1:Count(), 1, -1 do
		local item = self.List1:GetItem( i );
		
		// no player anymore?
		if( item.Player && !item.Player:IsValid() ) then
			self.List1:RemoveItem( i );
			item:Remove();

	
		// exists
		elseif( item.Player && item.Player:IsValid() ) then
			existing_players[ item.Player:EntIndex() ] = true;
			
			// update their name
			item:SetText( item.Player:Name() );
			
		end
		
	end
	
	
	// add players
	local pl;
	for _, pl in pairs( players ) do
		if( !existing_players[ pl:EntIndex() ] ) then
			// create
			local user = self.List1:CreateItem();
			user:SetText( pl:Name() );
			
			// admin
			local icon = 1;
			if( VMFSuite.AdminSystem:IsAdmin( pl ) ) then icon = 2; end
			
			// set icon.
			user:SetImages( icon, icon );
			user.Player = pl;
			
			
				
		end
	
	end

	
	
	// update the admin list!
	local existing_admins = {};
	
	// remove any list elements that don't exist anymore.
	for i = self.List2:Count(), 1, -1 do
		local item = self.List2:GetItem( i );
		
		// steamid?
		if( item.SteamID ) then
		
			// our steam id no longer is an admin?
			if( !VMFSuite.AdminSystem.Admins[ item.SteamID ] ) then
				// remove element.
				self.List2:RemoveItem( i );
				item:Remove();
				
			// it still is here
			else
				// add to existing.
				existing_admins[ item.SteamID ] = true;
				
			end
			
		end
	
	end
	
	// add admins to list.
	local admin;
	for _, admin in pairs( VMFSuite.AdminSystem.Admins ) do
	//	PrintTable( admin );
		
		// add.
		if( !existing_admins[ admin.steamid ] ) then
			// create
			local user = self.List2:CreateItem();
			user:SetText( admin.name );
			
			// admin
			local icon = 1;
			if( string.find( admin.flags, "+" ) ) then icon = 2; end
			
			// set icon.
			user:SetImages( icon, icon );
			user.SteamID = admin.steamid;
			
			
		
		end
	
	end
	
	
	
	//?
	self.List2:GetHandle():InvalidateLayout();
	
	//?
	self.List1:GetHandle():InvalidateLayout();
	
end


// perform layout
function PANEL:PerformLayout( )
	//
	local ofs = 4;
	
	// obj width.
	local width = self:GetWide() - 8;
	
	// position header1.
	self.Header1:SetPos( 4, ofs );
	self.Header1:SetSize( self:GetWide() - 8, 32 );
	ofs = ofs + 34;

	// position body1.
	self.Body1:SetPos( 4, ofs );
	self.Body1:SetSize( self:GetWide() - 8, 126 );
	ofs = ofs + 128;
	
	// position listbox.
	self.List1:SetPos( 4, 4 );
	self.List1:SetSize( self:GetWide() - 16, 96 );
	
	// position button
	self.Button1:SetPos( width - 58, 99 );
	self.Button1:SetSize( 54, 24 );
	

	
	
	// position header1.
	self.Header2:SetPos( 4, ofs );
	self.Header2:SetSize( self:GetWide() - 8, 32 );
	ofs = ofs + 34;

	// position body1.
	self.Body2:SetPos( 4, ofs );
	self.Body2:SetSize( self:GetWide() - 8, 126 );
	ofs = ofs + 128;
	
	// position listbox.
	self.List2:SetPos( 4, 4 );
	self.List2:SetSize( self:GetWide() - 16, 96 );
	
	// position button
	self.Button2:SetPos( width - 180, 99 );
	self.Button2:SetSize( 100, 24 );
	
	// position button
	self.Button3:SetPos( width - 76, 99 );
	self.Button3:SetSize( 72, 24 );
	

end


// draw
function PANEL:Paint( )
	// pain background.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	return true;
	
end

// register
vgui.Register( "ctl_usereditor", PANEL, "Panel" );




// create app framework control.
CtlUserEditor_class 	= Control_class:create( nil, false, "ctl_usereditor" );

